/////////////////////////////////////////////////////////////////////////////
// Name:        wx/imaggif.h
// Purpose:     wxImage GIF handler
// Author:      Vaclav Slavik, Guillermo Rodriguez Garcia, Gershon Elber, Troels K
// Copyright:   (c) 1999-2011 Vaclav Slavik, Guillermo Rodriguez Garcia, Gershon Elber, Troels K
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_IMAGGIF_H_
#define _WX_IMAGGIF_H_

#include "wx/image.h"

#include <vector>


//-----------------------------------------------------------------------------
// wxGIFHandler
//-----------------------------------------------------------------------------

#if wxUSE_GIF

#define wxIMAGE_OPTION_GIF_COMMENT wxT("GifComment")

#define wxIMAGE_OPTION_GIF_TRANSPARENCY           wxS("Transparency")
#define wxIMAGE_OPTION_GIF_TRANSPARENCY_HIGHLIGHT wxS("Highlight")
#define wxIMAGE_OPTION_GIF_TRANSPARENCY_UNCHANGED wxS("Unchanged")

struct wxRGB;
struct GifHashTableType;

class WXDLLIMPEXP_CORE wxGIFHandler : public wxImageHandler
{
public:
    wxGIFHandler() : wxImageHandler(
        wxT("GIF file"),
        wxT("gif"),
        wxBITMAP_TYPE_GIF,
        wxT("image/gif"))
    {
    }

#if wxUSE_STREAMS
    virtual bool LoadFile(wxImage *image, wxInputStream& stream,
                          bool verbose = true, int index = -1) override;
    virtual bool SaveFile(wxImage *image, wxOutputStream& stream,
                          bool verbose=true) override;

    // Save animated gif
    bool SaveAnimation(const std::vector<wxImage>& images, wxOutputStream *stream,
        bool verbose = true, int delayMilliSecs = 1000);

protected:
    virtual int DoGetImageCount(wxInputStream& stream) override;
    virtual bool DoCanRead(wxInputStream& stream) override;

    bool DoSaveFile(const wxImage&, wxOutputStream *, bool verbose,
        bool first, int delayMilliSecs, bool loop,
        const wxRGB *pal, int palCount,
        int mask_index);
#endif // wxUSE_STREAMS
protected:

    // Declarations for saving

    unsigned long m_crntShiftDWord;   /* For bytes decomposition into codes. */
    int m_pixelCount;
    struct GifHashTableType *m_hashTable = nullptr;
    wxInt16
      m_EOFCode,     /* The EOF LZ code. */
      m_clearCode,   /* The CLEAR LZ code. */
      m_runningCode, /* The next code algorithm can generate. */
      m_runningBits, /* The number of bits required to represent RunningCode. */
      m_maxCode1,    /* 1 bigger than max. possible code, in RunningBits bits. */
      m_crntCode,    /* Current algorithm code. */
      m_crntShiftState;    /* Number of bits in CrntShiftDWord. */
    wxUint8 m_LZBuf[256];   /* Compressed input is buffered here. */

    bool InitHashTable();
    void ClearHashTable();
    void InsertHashTable(unsigned long key, int code);
    int  ExistsHashTable(unsigned long key);

#if wxUSE_STREAMS
    bool CompressOutput(wxOutputStream *, int code);
    bool SetupCompress(wxOutputStream *, int bpp);
    bool CompressLine(wxOutputStream *, const wxUint8 *line, int lineLen);
#endif

private:
    wxDECLARE_DYNAMIC_CLASS(wxGIFHandler);
};

#endif // wxUSE_GIF

#endif // _WX_IMAGGIF_H_

